async function exportConduits() {
    const { jsPDF } = window.jspdf;

    if (!jsPDF) {
        console.error('jsPDF is not defined');
        return;
    }

    const pdf = new jsPDF('p', 'mm', 'a4');
    let y = 10; // Initial y position
    const lineHeight = 10; // Line height

    const setItems = document.querySelectorAll('#setsList li');
    setItems.forEach(setItem => {
        const text = setItem.innerText.trim();
        let backgroundColor = '';

        if (text.startsWith('Conduit:')) {
            backgroundColor = 'lightblue';
        } else if (text.startsWith('Wire (Non-CCC):')) {
            backgroundColor = 'lightcoral';
        } else if (text.startsWith('Wire (EGC):')) {
            backgroundColor = 'lightyellow';
        } else if (text.startsWith('Wire (GEC):')) {
            backgroundColor = 'lightpink';
        } else if (text.startsWith('Wire (SBJ):')) {
            backgroundColor = 'lightgray';
        } else if (text.startsWith('Wire:')) {
            backgroundColor = 'lightgreen';
        }

        // Set background color
        if (backgroundColor) {
            pdf.setFillColor(backgroundColor);
            pdf.rect(10, y - lineHeight + 2, pdf.internal.pageSize.getWidth() - 20, lineHeight, 'F');
        }

        // Add text
        pdf.text(text, 10, y);
        y += lineHeight;

        // Handle page breaks
        if (y > pdf.internal.pageSize.getHeight() - 10) {
            pdf.addPage();
            y = 10;
        }
    });

    pdf.save('conduits.pdf');
}

document.getElementById('exportButton').addEventListener('click', exportConduits);


// Function to export conduits to Excel
function exportToExcel() {
    const setsList = document.getElementById('setsList');
    const sets = setsList.getElementsByTagName('li');

    const data = [["Set Number", "Type", "Size", "Length (ft)", "Count", "Weight (lbs)", "Wire Fill (%)"]];
    for (let i = 0; i < sets.length; i++) {
        let setText = sets[i].innerText;

        // Remove action button texts
        setText = setText.replace(/Check Ampacity\s*Check EGC\s*Check GEC\s*Check SBJ\s*Edit\s*Remove/g, '');

        // Extract set details
        const setLines = setText.split('\n');
        const setNumber = setLines[0].match(/Set (\d+):/)[1];
        let setDetails = [];

        for (let line of setLines.slice(1)) {
            if (line.trim() !== "") {
                const match = line.match(/Type - ([^,]+), Size - ([^,]+), Length - ([^,]+) ft, Count - (\d+)/);
                if (match) {
                    setDetails.push([setNumber, match[1], match[2], match[3], match[4]]);
                } else {
                    const weightMatch = line.match(/Weight - ([\d.]+) lbs/);
                    const fillMatch = line.match(/Wire Fill - ([\d.]+)%/);
                    if (weightMatch) {
                        setDetails.forEach(detail => detail.push(weightMatch[1]));
                    }
                    if (fillMatch) {
                        setDetails.forEach(detail => detail.push(fillMatch[1]));
                    }
                }
            }
        }

        data.push(...setDetails);
    }

    const ws = XLSX.utils.aoa_to_sheet(data);
    const wb = XLSX.utils.book_new();
    XLSX.utils.book_append_sheet(wb, ws, 'Conduits and Wires');

    XLSX.writeFile(wb, 'conduits_and_wires.xlsx');
}

document.getElementById('exportPdfButton').addEventListener('click', exportConduits);
document.getElementById('exportExcelButton').addEventListener('click', exportToExcel);
